// SeriesTxtSrcDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SeriesTxtSrc.h"
#include "series.h"
#include "surfaceseries.h"
#include "waterfallseries.h"
#include "TeeChartDefines.h"
#include "SeriesTxtSrcDlg.h"
#include "SeriesTextField.h"
#include "aspect.h"
#include "Environment.h"
#include "teeopengl.h"

//To use VC++ locale id :
//#include "locale.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

	

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSeriesTxtSrcDlg dialog

CSeriesTxtSrcDlg::CSeriesTxtSrcDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSeriesTxtSrcDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSeriesTxtSrcDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSeriesTxtSrcDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSeriesTxtSrcDlg)
	DDX_Control(pDX, IDC_TCHART1, m_Chart1);
	DDX_Control(pDX, IDC_SERIESTEXTSOURCE1, m_TextSource1);
	DDX_Control(pDX, IDC_TEECOMMANDER1, m_Commander1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSeriesTxtSrcDlg, CDialog)
	//{{AFX_MSG_MAP(CSeriesTxtSrcDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	ON_BN_CLICKED(IDC_BUTTON4, OnButton4)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSeriesTxtSrcDlg message handlers

BOOL CSeriesTxtSrcDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_Commander1.SetChartLink(m_Chart1.GetChartLink());
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSeriesTxtSrcDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSeriesTxtSrcDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSeriesTxtSrcDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSeriesTxtSrcDlg::OnButton1() 
{
	m_Chart1.RemoveAllSeries();

	SeriesIndex.vt=VT_INT;
	SeriesIndex.intVal= m_Chart1.AddSeries(scWaterfall);

	m_Chart1.Series(0).GetAsWaterfall().SetIrregularGrid(true);

	AddData();

}

void CSeriesTxtSrcDlg::OnButton2() 
{

	m_Chart1.RemoveAllSeries();

	SeriesIndex.vt=VT_INT;
	SeriesIndex.intVal= m_Chart1.AddSeries(scTriSurface);

	AddData();

}

void CSeriesTxtSrcDlg::OnButton3() 
{
	// TODO: Add your control notification handler code here
	m_Chart1.GetAspect().GetOpenGL().SetActive(!m_Chart1.GetAspect().GetOpenGL().GetActive());
}

void CSeriesTxtSrcDlg::OnButton4() 
{
	m_Chart1.RemoveAllSeries();

	// **************************************
	// Option, can use SeriesIndex as ISeries
    // for SeriesTextSource.SetSeries
	// **************************************

    SeriesIndex.vt=VT_DISPATCH;

	m_Chart1.AddSeries(scSurface);
	CSeries Surf=m_Chart1.Series(0);
	SeriesIndex.pdispVal=Surf;

	m_Chart1.Series(0).GetAsSurface().SetIrregularGrid(true);

    AddData();

}

void CSeriesTxtSrcDlg::AddData()
{

	// Use the SeriesTextSourceComponent to import data
	// from a text file.
	// It's sensitive to decimal type in text so we do a check
	// here on the machine locale.
     
	/********************************************************
	// Could check Locale via MFC
	LCID lcid;
	CHAR lpszLang[2];

	lcid=GetThreadLocale(); 
    int rc = GetLocaleInfo(lcid, LOCALE_SDECIMAL, lpszLang, 2);
	
	if (CString(&lpszLang[0]).Compare(CString(","))==0) {
		m_TextSource1.SetFileName("SurfaceDataComma.txt");
    }
	else {
		m_TextSource1.SetFileName("SurfaceDataPoint.txt");
    }
	*********************************************************/

    //Checking Locale using TeeChart:
	if (CString(m_Chart1.GetEnvironment().GetDecimalSeparator()).Compare(CString(","))==0) {
		m_TextSource1.SetFileName("SurfaceDataComma.txt");
    }
	else {
		m_TextSource1.SetFileName("SurfaceDataPoint.txt");
    }

	// The following line only necessary if SeriesIndex as VT_INT.
    m_TextSource1.SetChartLink(m_Chart1.GetChartLink());
	m_TextSource1.SetSeries(SeriesIndex);
	m_TextSource1.SetFieldSeparator(";");
    m_TextSource1.AddField("x",1);
	m_TextSource1.AddField("y",2);
	m_TextSource1.AddField("z",3);
	m_TextSource1.SetActive(true);
}
